//
//  CRPatternOverPath.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 4/8/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRPathProcessor.h"

extern NSString* const CRPatternOverPathBrushesKey;
extern NSString* const CRPatternOverPathSeedKey;
extern NSString* const CRPatternOverPathBrushSizeKey;
extern NSString* const CRPatternOverPathDispersionKey;
extern NSString* const CRPatternOverPathDensityKey;
extern NSString* const CRPatternOverPathApplyShadowKey;

//////////////////////////////////////////////////////////////////////
// CRPatternOverPathPlain
// This processor applies specified patter over the path and
// produces a bitmap plane with the strokes
//////////////////////////////////////////////////////////////////////
@interface CRPatternOverPath : CRPathProcessor
{
@private
	NSSize		scaledSize;		// current cale size
	NSArray*	scaledBrushes;	// scaled brushes
}

@property (nonatomic, copy)	  NSArray*	brushImages;	// brush image
@property (nonatomic, assign) NSInteger	seed;			// random seed - help to get the same path every run
@property (nonatomic, assign) CGFloat	brushSize;		// brush size in % of the inputImage
@property (nonatomic, assign) CGFloat	dispersion;		// brush dispersion
@property (nonatomic, assign) CGFloat	density;		// brush strokes density
@property (nonatomic, assign) BOOL		applyShadow;	// signals whether shadow should be applied to strokes

- (NSAffineTransform *)transformForBrushSize:(NSSize)szBrush atPoint:(NSPoint)point;
- (void)applyBrushStrokeAtPoint:(NSPoint)point withBrush:(id)brush;
- (CIImage *)brushFromImage:(id)brushImage withSize:(NSSize&)szBrush;
- (void)applyPathWithArea:(NSAffineTransform *)areaTransform;
- (CGFloat)safeInset;

@end